package org.moddingx.libx.impl.datagen.loot;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;

import java.util.List;
import java.util.function.Function;

public class LootData {

    public static LootPoolSingletonContainer.Builder<?> stack(ItemStack stack) {
        LootPoolSingletonContainer.Builder<?> entry = LootItem.m_79579_(stack.m_41720_());
        if (stack.m_41613_() != 1) {
            entry.m_79078_(SetItemCountFunction.m_165412_(ConstantValue.m_165692_(stack.m_41613_())));
        }
        if (stack.m_41773_() != 0) {
            float damage = (stack.m_41776_() - stack.m_41773_()) / (float) stack.m_41776_();
            entry.m_79078_(SetItemDamageFunction.m_165430_(ConstantValue.m_165692_(damage)));
        }
        if (stack.m_41782_()) {
            //noinspection deprecation
            entry.m_79078_(SetNbtFunction.m_81187_(stack.m_41784_()));
        }
        return entry;
    }
    
    public static <T> LootPoolEntryContainer.Builder<?> combineBy(Function<List<LootPoolEntryContainer.Builder<?>>, LootPoolEntryContainer.Builder<?>> combineFunc, Function<T, LootPoolEntryContainer.Builder<?>> extract, List<T> loot) {
        return combineBy(combineFunc, loot.stream().map(extract).toList());
    }
    
    public static LootPoolEntryContainer.Builder<?> combineBy(Function<List<LootPoolEntryContainer.Builder<?>>, LootPoolEntryContainer.Builder<?>> combineFunc, List<LootPoolEntryContainer.Builder<?>> loot) {
        if (loot.isEmpty()) {
            return EmptyLootItem.m_79533_();
        } else if (loot.size() == 1) {
            return loot.get(0);
        } else {
            return combineFunc.apply(loot);
        }
    }
}
