package org.moddingx.libx.impl.datagen.tags;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.moddingx.libx.datagen.provider.tags.CommonTagsProviderBase;
import org.moddingx.libx.impl.base.decoration.blocks.*;
import org.moddingx.libx.impl.tags.InternalTags;

public class DecorationTags {

    public static void addTags(Block block, CommonTagsProviderBase provider, Runnable initInternal) {
        if (block instanceof DecoratedWoodBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.LOGS).m_255245_(decorated);
            if (new ItemStack(decorated).getBurnTime(null) > 0) {
                provider.block(InternalTags.Blocks.LOGS_THAT_BURN).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedSlabBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.SLABS).m_255245_(decorated);
            if (decorated.parent.getContext().material().isWood()) {
                provider.block(InternalTags.Blocks.WOODEN_SLABS).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedStairBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.STAIRS).m_255245_(decorated);
            if (decorated.parent.getContext().material().isWood()) {
                provider.block(InternalTags.Blocks.WOODEN_STAIRS).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedWallBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.WALLS).m_255245_(decorated);
        } else if (block instanceof DecoratedFenceBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.FENCES).m_255245_(decorated);
            if (decorated.parent.getContext().material().isWood()) {
                provider.block(InternalTags.Blocks.WOODEN_FENCES).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedFenceGateBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.FENCE_GATES).m_255245_(decorated);
        } else if (block instanceof DecoratedDoorBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.DOORS).m_255245_(decorated);
            if (decorated.parent.getContext().material().isWood()) {
                provider.block(InternalTags.Blocks.WOODEN_DOORS).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedTrapdoorBlock decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.TRAPDOORS).m_255245_(decorated);
            if (decorated.parent.getContext().material().isWood()) {
                provider.block(InternalTags.Blocks.WOODEN_TRAPDOORS).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedButton decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.BUTTONS).m_255245_(decorated);
            if (decorated.parent.getContext().material().isWood()) {
                provider.block(InternalTags.Blocks.WOODEN_BUTTONS).m_255245_(decorated);
            }
            if (decorated.parent.getContext().material().isStone()) {
                provider.block(InternalTags.Blocks.STONE_BUTTONS).m_255245_(decorated);
            }
        } else if (block instanceof DecoratedPressurePlate decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.PRESSURE_PLATES).m_255245_(decorated);
            switch (decorated.sensitivity) {
                case EVERYTHING -> provider.block(InternalTags.Blocks.WOODEN_PRESSURE_PLATES).m_255245_(decorated);
                case MOBS -> provider.block(InternalTags.Blocks.STONE_PRESSURE_PLATES).m_255245_(decorated);
                default -> {}
            }
        } else if (block instanceof DecoratedSign.Standing decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.SIGNS).m_255245_(decorated);
            provider.block(InternalTags.Blocks.STANDING_SIGNS).m_255245_(decorated);
        } else if (block instanceof DecoratedSign.Wall decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.SIGNS).m_255245_(decorated);
            provider.block(InternalTags.Blocks.WALL_SIGNS).m_255245_(decorated);
        } else if (block instanceof DecoratedHangingSign.Ceiling decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.HANGING_SIGNS).m_255245_(decorated);
            provider.block(InternalTags.Blocks.CEILING_HANGING_SIGNS).m_255245_(decorated);
        } else if (block instanceof DecoratedHangingSign.Wall decorated) {
            initInternal.run();
            provider.block(InternalTags.Blocks.HANGING_SIGNS).m_255245_(decorated);
            provider.block(InternalTags.Blocks.WALL_HANGING_SIGNS).m_255245_(decorated);
        }
    }
}
