package org.moddingx.libx.impl.menu.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.menu.GenericMenu;
import org.moddingx.libx.render.RenderHelper;

import javax.annotation.Nonnull;

// Screen for the GenericContainerMenu. Do not use manually.
public class GenericScreen extends AbstractContainerScreen<GenericMenu> {
    
    private final GenericMenu menu;

    public GenericScreen(GenericMenu menu, Inventory playerContainer, Component title) {
        super(menu, playerContainer, title);
        this.menu = menu;
        this.f_97726_ = menu.width;
        this.f_97727_ = menu.height;
        this.f_97730_ = menu.invX;
        this.f_97731_ = menu.invY - 11;
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }
    
    @Override
    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        if (this.f_96541_ != null) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            RenderHelper.renderGuiBackground(graphics, i, j, this.f_97726_, this.f_97727_);
            for (Pair<Integer, Integer> slot : this.menu.slotList) {
                graphics.m_280218_(RenderHelper.TEXTURE_CHEST_GUI, i + slot.getLeft() - 1, j + slot.getRight() - 1, 25, 35, 18, 18);
            }
            graphics.m_280218_(RenderHelper.TEXTURE_CHEST_GUI, i + this.menu.invX - 1, j + this.menu.invY - 1, 7, 139, 162, 76);
        }
    }
}
