package org.moddingx.libx.impl.sandbox;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

import javax.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

// When we know, how a holder is used.
// Mimics a direct holder, but delegates to some other holder.
// Value can be changed over time.
public class FakeHolder<T> implements Holder<T> {

    private Holder<T> holder;

    public FakeHolder(Holder<T> initial) {
        this.set(initial);
    }

    public void set(Holder<T> value) {
        try {
            value.get();
        } catch (IllegalStateException e) {
            throw new IllegalArgumentException("Unbound holder: " + value, e);
        }
        this.holder = value;
    }

    @Nonnull
    @Override
    public T m_203334_() {
        return this.holder.m_203334_();
    }

    @Override
    public boolean m_203633_() {
        return true;
    }

    @Override
    public boolean m_203373_(@Nonnull ResourceLocation id) {
        return false;
    }

    @Override
    public boolean m_203565_(@Nonnull ResourceKey<T> key) {
        return false;
    }

    @Override
    public boolean m_203425_(@Nonnull Predicate<ResourceKey<T>> predicate) {
        return false;
    }

    @Override
    public boolean m_203656_(@Nonnull TagKey<T> key) {
        return false;
    }

    @Nonnull
    @Override
    public Stream<TagKey<T>> m_203616_() {
        return Stream.empty();
    }

    @Nonnull
    @Override
    public Either<ResourceKey<T>, T> m_203439_() {
        return Either.right(this.m_203334_());
    }

    @Nonnull
    @Override
    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.empty();
    }

    @Nonnull
    @Override
    public Holder.Kind m_203376_() {
        return Holder.Kind.DIRECT;
    }

    @Override
    public boolean m_203401_(@Nonnull HolderOwner<T> owner) {
        return true;
    }
}
