package org.moddingx.libx.impl.sandbox.density;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

import javax.annotation.Nonnull;

import net.minecraft.world.level.levelgen.DensityFunction.ContextProvider;
import net.minecraft.world.level.levelgen.DensityFunction.FunctionContext;
import net.minecraft.world.level.levelgen.DensityFunction.Visitor;

public record DensityClamp(DensityFunction density, double min, double max) implements DensityFunction {

    public static final KeyDispatchDataCodec<DensityClamp> CODEC = KeyDispatchDataCodec.m_216238_(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    DensityFunction.f_208218_.fieldOf("density").forGetter(DensityClamp::density),
                    Codec.DOUBLE.fieldOf("min").forGetter(DensityClamp::min),
                    Codec.DOUBLE.fieldOf("max").forGetter(DensityClamp::max)
            ).apply(instance, DensityClamp::new))
    );

    @Nonnull
    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    @Override
    public double m_207386_(@Nonnull FunctionContext context) {
        return Mth.m_14008_(this.density().m_207386_(context), this.min(), this.max());
    }

    @Override
    public void m_207362_(@Nonnull double[] array, @Nonnull ContextProvider provider) {
        this.density().m_207362_(array, provider);
        for (int i = 0; i < array.length; i++) {
            array[i] = Mth.m_14008_(array[i], this.min(), this.max());
        }
    }

    @Nonnull
    @Override
    public DensityFunction m_207456_(@Nonnull Visitor visitor) {
        return visitor.m_214017_(new DensityClamp(this.density().m_207456_(visitor), this.min(), this.max()));
    }

    @Override
    public double m_207402_() {
        return Math.max(this.density().m_207402_(), this.min());
    }

    @Override
    public double m_207401_() {
        return Math.min(this.density().m_207401_(), this.max());
    }
}
