package org.moddingx.libx.impl.sandbox.density;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

import javax.annotation.Nonnull;

import net.minecraft.world.level.levelgen.DensityFunction.FunctionContext;

public record DensityDebug(Direction.Axis axis, double scale) implements DensityFunction.SimpleFunction {

    public static final KeyDispatchDataCodec<DensityDebug> CODEC = KeyDispatchDataCodec.m_216238_(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    Direction.Axis.f_122447_.fieldOf("axis").forGetter(DensityDebug::axis),
                    Codec.DOUBLE.fieldOf("scale").forGetter(DensityDebug::scale)
            ).apply(instance, DensityDebug::new))
    );

    @Nonnull
    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    @Override
    public double m_207386_(@Nonnull FunctionContext context) {
        return this.scale * switch (this.axis) {
            case X -> context.m_207115_();
            case Y -> context.m_207114_();
            case Z -> context.m_207113_();
        };
    }

    @Override
    public double m_207402_() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double m_207401_() {
        return Double.POSITIVE_INFINITY;
    }
}
