package org.moddingx.libx.impl.sandbox.density;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

import javax.annotation.Nonnull;

import net.minecraft.world.level.levelgen.DensityFunction.ContextProvider;
import net.minecraft.world.level.levelgen.DensityFunction.FunctionContext;
import net.minecraft.world.level.levelgen.DensityFunction.Visitor;

public record DensityInfluence(DensityFunction base, DensityFunction modifier, DensityFunction influence, double minInfluence, double maxInfluence) implements DensityFunction {

    public static final KeyDispatchDataCodec<DensityInfluence> CODEC = KeyDispatchDataCodec.m_216238_(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    DensityFunction.f_208218_.fieldOf("base").forGetter(DensityInfluence::base),
                    DensityFunction.f_208218_.fieldOf("modifier").forGetter(DensityInfluence::modifier),
                    DensityFunction.f_208218_.fieldOf("influence").forGetter(DensityInfluence::influence),
                    Codec.DOUBLE.optionalFieldOf("min_influence", -1d).forGetter(DensityInfluence::minInfluence),
                    Codec.DOUBLE.optionalFieldOf("max_influence", -1d).forGetter(DensityInfluence::maxInfluence)
            ).apply(instance, DensityInfluence::new))
    );

    @Nonnull
    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    @Override
    public double m_207386_(@Nonnull FunctionContext context) {
        double influence = this.minInfluence() + (this.influence().m_207386_(context) / (this.maxInfluence() - this.minInfluence()));
        return this.base().m_207386_(context) + influence * this.modifier().m_207386_(context);
    }

    @Override
    public void m_207362_(@Nonnull double[] array, @Nonnull ContextProvider provider) {
        double[] influence = new double[array.length];
        double[] modifier = new double[array.length];
        this.base().m_207362_(array, provider);
        this.influence().m_207362_(influence, provider);
        this.modifier().m_207362_(modifier, provider);
        for (int i = 0; i < array.length; i++) {
            array[i] += (this.minInfluence() + (influence[i] / (this.maxInfluence() - this.minInfluence()))) * modifier[i];
        }
    }

    @Nonnull
    @Override
    public DensityFunction m_207456_(@Nonnull Visitor visitor) {
        return visitor.m_214017_(new DensityInfluence(this.base().m_207456_(visitor), this.modifier().m_207456_(visitor), this.influence().m_207456_(visitor), this.minInfluence(), this.maxInfluence()));
    }

    @Override
    public double m_207402_() {
        return this.base().m_207402_() + (this.minInfluence() + (this.influence().m_207402_() / (this.maxInfluence() - this.minInfluence()))) * this.modifier().m_207402_();
    }

    @Override
    public double m_207401_() {
        return this.base().m_207401_() + (this.minInfluence() + (this.influence().m_207401_() / (this.maxInfluence() - this.minInfluence()))) * this.modifier().m_207401_();
    }
}
