package org.moddingx.libx.impl.sandbox.density;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

import javax.annotation.Nonnull;

import net.minecraft.world.level.levelgen.DensityFunction.ContextProvider;
import net.minecraft.world.level.levelgen.DensityFunction.FunctionContext;
import net.minecraft.world.level.levelgen.DensityFunction.Visitor;

public record DensityLerp(DensityFunction argument1, DensityFunction argument2, DensityFunction niveau, double mean, double deviation) implements DensityFunction {

    public static final KeyDispatchDataCodec<DensityLerp> CODEC = KeyDispatchDataCodec.m_216238_(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    DensityFunction.f_208218_.fieldOf("argument1").forGetter(DensityLerp::argument1),
                    DensityFunction.f_208218_.fieldOf("argument2").forGetter(DensityLerp::argument2),
                    DensityFunction.f_208218_.fieldOf("niveau").forGetter(DensityLerp::niveau),
                    Codec.DOUBLE.optionalFieldOf("mean", 0d).forGetter(DensityLerp::mean),
                    Codec.DOUBLE.optionalFieldOf("deviation", 1d).forGetter(DensityLerp::deviation)
            ).apply(instance, DensityLerp::new))
    );
    
    @Nonnull
    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    @Override
    public double m_207386_(@Nonnull FunctionContext context) {
        double a = this.argument1().m_207386_(context);
        double b = this.argument2().m_207386_(context);
        double n = Mth.m_14008_(this.niveau().m_207386_(context), this.mean() - this.deviation(), this.mean() + this.deviation());
        return Mth.m_14139_(((n - this.mean()) / (2 * this.deviation())) + 0.5, a, b);
    }

    @Override
    public void m_207362_(@Nonnull double[] array, @Nonnull ContextProvider provider) {
        double[] a = new double[array.length];
        double[] b = new double[array.length];
        this.niveau().m_207362_(array, provider);
        this.argument1().m_207362_(a, provider);
        this.argument2().m_207362_(b, provider);
        double n;
        for (int i = 0; i < array.length; i++) {
            n = Mth.m_14008_(array[i], this.mean() - this.deviation(), this.mean() + this.deviation());
            array[i] = Mth.m_14139_(((n - this.mean()) / (2 * this.deviation())) + 0.5, a[i], b[i]);
        }
    }

    @Nonnull
    @Override
    public DensityFunction m_207456_(@Nonnull Visitor visitor) {
        return visitor.m_214017_(new DensityLerp(this.argument1().m_207456_(visitor), this.argument2().m_207456_(visitor), this.niveau().m_207456_(visitor), this.mean(), this.deviation()));
    }

    @Override
    public double m_207402_() {
        return Math.min(this.argument1().m_207402_(), this.argument2().m_207402_());
    }

    @Override
    public double m_207401_() {
        return Math.max(this.argument1().m_207401_(), this.argument2().m_207401_());
    }
}
