package org.moddingx.libx.impl.sandbox.density;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.blending.Blender;

import javax.annotation.Nonnull;
import java.util.Objects;

import net.minecraft.world.level.levelgen.DensityFunction.ContextProvider;
import net.minecraft.world.level.levelgen.DensityFunction.FunctionContext;
import net.minecraft.world.level.levelgen.DensityFunction.Visitor;

public class DensitySmash implements DensityFunction {

    public static final KeyDispatchDataCodec<DensitySmash> CODEC = KeyDispatchDataCodec.m_216238_(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    DensityFunction.f_208218_.fieldOf("density").forGetter(d -> d.wrapped),
                    Direction.Axis.f_122447_.fieldOf("axis").forGetter(d -> d.axis)
            ).apply(instance, DensitySmash::new))
    );
    
    private final DensityFunction wrapped;
    private final Direction.Axis axis;
    
    private final SmashedContext context;
    private final SmashedProvider provider;

    public DensitySmash(DensityFunction wrapped, Direction.Axis axis) {
        this.wrapped = wrapped;
        this.axis = axis;
        
        this.context = new SmashedContext();
        this.provider = new SmashedProvider();
    }

    @Nonnull
    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    @Override
    public double m_207386_(@Nonnull FunctionContext context) {
        this.context.parent = context;
        return this.wrapped.m_207386_(this.context);
    }

    @Override
    public void m_207362_(@Nonnull double[] array, @Nonnull ContextProvider provider) {
        this.provider.parent = provider;
        this.wrapped.m_207362_(array, provider);
    }

    @Nonnull
    @Override
    public DensityFunction m_207456_(@Nonnull Visitor visitor) {
        return visitor.m_214017_(new DensitySmash(this.wrapped.m_207456_(visitor), this.axis));
    }

    @Override
    public double m_207402_() {
        return this.wrapped.m_207402_();
    }

    @Override
    public double m_207401_() {
        return this.wrapped.m_207401_();
    }

    @Nonnull
    @Override
    public DensityFunction m_208220_(double minValue, double maxValue) {
        return new DensitySmash(this.wrapped.m_208220_(minValue, maxValue), this.axis);
    }

    @Nonnull
    @Override
    public DensityFunction m_208229_() {
        return new DensitySmash(this.wrapped.m_208229_(), this.axis);
    }

    @Nonnull
    @Override
    public DensityFunction m_208230_() {
        return new DensitySmash(this.wrapped.m_208230_(), this.axis);
    }

    @Nonnull
    @Override
    public DensityFunction m_208231_() {
        return new DensitySmash(this.wrapped.m_208231_(), this.axis);
    }

    @Nonnull
    @Override
    public DensityFunction m_208232_() {
        return new DensitySmash(this.wrapped.m_208232_(), this.axis);
    }

    @Nonnull
    @Override
    public DensityFunction m_208233_() {
        return new DensitySmash(this.wrapped.m_208233_(), this.axis);
    }

    @Nonnull
    @Override
    public DensityFunction m_208234_() {
        return new DensitySmash(this.wrapped.m_208234_(), this.axis);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DensitySmash other)) return false;
        return Objects.equals(this.wrapped, other.wrapped) && this.axis == other.axis;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.wrapped, this.axis);
    }

    @Override
    public String toString() {
        return "DensitySmash[wrapped=" + this.wrapped + ", axis=" + this.axis + "]";
    }

    private class SmashedContext implements FunctionContext {
        
        private FunctionContext parent;

        @Override
        public int m_207115_() {
            return DensitySmash.this.axis == Direction.Axis.X ? 0 : this.parent.m_207115_();
        }

        @Override
        public int m_207114_() {
            return DensitySmash.this.axis == Direction.Axis.Y ? 0 : this.parent.m_207114_();
        }

        @Override
        public int m_207113_() {
            return DensitySmash.this.axis == Direction.Axis.Z ? 0 : this.parent.m_207113_();
        }

        @Nonnull
        @Override
        public Blender m_188743_() {
            return this.parent.m_188743_();
        }
    }
    
    private class SmashedProvider implements ContextProvider {
        
        private ContextProvider parent;

        @Nonnull
        @Override
        public FunctionContext m_207263_(int arrayIndex) {
            DensitySmash.this.context.parent = this.parent.m_207263_(arrayIndex);
            return DensitySmash.this.context;
        }

        @Override
        public void m_207207_(@Nonnull double[] values, @Nonnull DensityFunction function) {
            for(int i = 0; i < values.length; i++) {
               values[i] = function.m_207386_(this.m_207263_(i));
            }
        }
    }
}
