package org.moddingx.libx.impl.tags;

import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.moddingx.libx.LibX;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

// Required, so there are no conflicts if copy methods are called with vanilla tags in datagen.
public class InternalTags {
    
    public static class Items {
        
        private static final Map<TagKey<Item>, TagKey<Item>> TAGS = new HashMap<>();
        private static final Map<TagKey<Block>, TagKey<Item>> COPIES = new HashMap<>();

        public static final TagKey<Item> LOGS = wrap(ItemTags.f_13182_, Blocks.LOGS);
        public static final TagKey<Item> LOGS_THAT_BURN = wrap(ItemTags.f_13181_, Blocks.LOGS_THAT_BURN);
        public static final TagKey<Item> WOODEN_BUTTONS = wrap(ItemTags.f_13170_, Blocks.WOODEN_BUTTONS);
        public static final TagKey<Item> STONE_BUTTONS = wrap(ItemTags.f_279629_, Blocks.STONE_BUTTONS);
        public static final TagKey<Item> BUTTONS = wrap(ItemTags.f_13171_, Blocks.BUTTONS);
        public static final TagKey<Item> WOODEN_DOORS = wrap(ItemTags.f_13173_, Blocks.WOODEN_DOORS);
        public static final TagKey<Item> WOODEN_STAIRS = wrap(ItemTags.f_13174_, Blocks.WOODEN_STAIRS);
        public static final TagKey<Item> WOODEN_SLABS = wrap(ItemTags.f_13175_, Blocks.WOODEN_SLABS);
        public static final TagKey<Item> WOODEN_FENCES = wrap(ItemTags.f_13176_, Blocks.WOODEN_FENCES);
        public static final TagKey<Item> WOODEN_PRESSURE_PLATES = wrap(ItemTags.f_13177_, Blocks.WOODEN_PRESSURE_PLATES);
        public static final TagKey<Item> WOODEN_TRAPDOORS = wrap(ItemTags.f_13178_, Blocks.WOODEN_TRAPDOORS);
        public static final TagKey<Item> DOORS = wrap(ItemTags.f_13179_, Blocks.DOORS);
        public static final TagKey<Item> STAIRS = wrap(ItemTags.f_13138_, Blocks.STAIRS);
        public static final TagKey<Item> SLABS = wrap(ItemTags.f_13139_, Blocks.SLABS);
        public static final TagKey<Item> WALLS = wrap(ItemTags.f_13140_, Blocks.WALLS);
        public static final TagKey<Item> TRAPDOORS = wrap(ItemTags.f_13144_, Blocks.TRAPDOORS);
        public static final TagKey<Item> FENCES = wrap(ItemTags.f_13147_, Blocks.FENCES);
        public static final TagKey<Item> FENCE_GATES = wrap(ItemTags.f_254662_, Blocks.FENCE_GATES);
        public static final TagKey<Item> SIGNS = wrap(ItemTags.f_13157_, Blocks.STANDING_SIGNS);
        public static final TagKey<Item> HANGING_SIGNS = wrap(ItemTags.f_244389_, Blocks.CEILING_HANGING_SIGNS);
        
        private static TagKey<Item> wrap(TagKey<Item> tag, TagKey<Block> blockTag) {
            TagKey<Item> newTag = ItemTags.create(LibX.getInstance().resource("impl_" + tag.f_203868_().m_135815_()));
            TAGS.put(tag, newTag);
            COPIES.put(blockTag, newTag);
            return newTag;
        }

        public static Map<TagKey<Item>, TagKey<Item>> getTags() {
            return Collections.unmodifiableMap(TAGS);
        }

        public static Map<TagKey<Block>, TagKey<Item>> getCopies() {
            return Collections.unmodifiableMap(COPIES);
        }
    }
    
    public static class Blocks {

        private static final Map<TagKey<Block>, TagKey<Block>> TAGS = new HashMap<>();

        public static final TagKey<Block> LOGS = wrap(BlockTags.f_13106_);
        public static final TagKey<Block> LOGS_THAT_BURN = wrap(BlockTags.f_13105_);
        public static final TagKey<Block> WOODEN_BUTTONS = wrap(BlockTags.f_13092_);
        public static final TagKey<Block> STONE_BUTTONS = wrap(BlockTags.f_279568_);
        public static final TagKey<Block> BUTTONS = wrap(BlockTags.f_13093_);
        public static final TagKey<Block> WOODEN_DOORS = wrap(BlockTags.f_13095_);
        public static final TagKey<Block> WOODEN_STAIRS = wrap(BlockTags.f_13096_);
        public static final TagKey<Block> WOODEN_SLABS = wrap(BlockTags.f_13097_);
        public static final TagKey<Block> WOODEN_FENCES = wrap(BlockTags.f_13098_);
        public static final TagKey<Block> PRESSURE_PLATES = wrap(BlockTags.f_13099_);
        public static final TagKey<Block> WOODEN_PRESSURE_PLATES = wrap(BlockTags.f_13100_);
        public static final TagKey<Block> STONE_PRESSURE_PLATES = wrap(BlockTags.f_13101_);
        public static final TagKey<Block> WOODEN_TRAPDOORS = wrap(BlockTags.f_13102_);
        public static final TagKey<Block> DOORS = wrap(BlockTags.f_13103_);
        public static final TagKey<Block> STAIRS = wrap(BlockTags.f_13030_);
        public static final TagKey<Block> SLABS = wrap(BlockTags.f_13031_);
        public static final TagKey<Block> WALLS = wrap(BlockTags.f_13032_);
        public static final TagKey<Block> TRAPDOORS = wrap(BlockTags.f_13036_);
        public static final TagKey<Block> FENCES = wrap(BlockTags.f_13039_);
        public static final TagKey<Block> FENCE_GATES = wrap(BlockTags.f_13055_);
        public static final TagKey<Block> STANDING_SIGNS = wrap(BlockTags.f_13066_);
        public static final TagKey<Block> WALL_SIGNS = wrap(BlockTags.f_13067_);
        public static final TagKey<Block> SIGNS = wrap(BlockTags.f_13068_);
        public static final TagKey<Block> CEILING_HANGING_SIGNS = wrap(BlockTags.f_243838_);
        public static final TagKey<Block> WALL_HANGING_SIGNS = wrap(BlockTags.f_244544_);
        public static final TagKey<Block> HANGING_SIGNS = wrap(BlockTags.f_244320_);

        private static TagKey<Block> wrap(TagKey<Block> tag) {
            TagKey<Block> newTag = BlockTags.create(LibX.getInstance().resource("impl_" + tag.f_203868_().m_135815_()));
            TAGS.put(tag, newTag);
            return newTag;
        }

        public static Map<TagKey<Block>, TagKey<Block>> getTags() {
            return Collections.unmodifiableMap(TAGS);
        }
    }
}
