package org.moddingx.libx.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Wraps an {@link IItemHandlerModifiable} to a vanilla {@link Container}.
 */
public class VanillaWrapper implements Container {

    public final IItemHandlerModifiable handler;

    @Nullable
    public final Runnable changed;

    /**
     * Wraps the given {@link IItemHandlerModifiable} to a vanilla {@link Container}.
     *
     * @param changed A runnable which is always called when {@link Container#setChanged()}
     *                is called on the vanilla container.
     */
    public VanillaWrapper(IItemHandlerModifiable handler, @Nullable Runnable changed) {
        this.handler = handler;
        this.changed = changed;
    }

    @Override
    public int m_6643_() {
        return this.handler.getSlots();
    }

    @Override
    public boolean m_7983_() {
        for (int slot = 0; slot < this.handler.getSlots(); slot++) {
            if (!this.handler.getStackInSlot(slot).m_41619_())
                return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public ItemStack m_8020_(int index) {
        return this.handler.getStackInSlot(index);
    }

    @Override
    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.handler.extractItem(index, count, false);
        this.m_6596_();
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack m_8016_(int index) {
        ItemStack stack = this.handler.getStackInSlot(index).m_41777_();
        this.handler.setStackInSlot(index, ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    @Override
    public void m_6836_(int index, @Nonnull ItemStack stack) {
        this.handler.setStackInSlot(index, stack);
        this.m_6596_();
    }

    @Override
    public void m_6596_() {
        if (this.changed != null) {
            this.changed.run();
        }
    }

    @Override
    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    @Override
    public boolean m_7013_(int index, @Nonnull ItemStack stack) {
        return this.handler.isItemValid(index, stack);
    }

    @Override
    public void m_6211_() {
        if (this.handler instanceof IAdvancedItemHandlerModifiable adv) {
            adv.clear();
        } else {
            for (int i = 0; i < this.handler.getSlots(); i++) {
                this.handler.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }
}
