package org.moddingx.libx.menu;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A base class for menus that handles basic menu logic such as shift-clicks,
 * and laying out slots.
 * 
 * There are some things you need to pay attention to if you want to use this:
 * 
 * <ul>
 *     <li>Always add player inventory slots with {@link #layoutPlayerInventorySlots(int, int)}</li>
 *     <li>Add input slots, THEN output slots and THEN player inventory.</li>
 * </ul>
 * 
 * Call the super constructor with
 * 
 * <ul>
 *     <li>firstOutputSlot = the number of input slot you have / the first output slot number</li>
 *     <li>firstInventorySlot = the number of input slots and output slots you have / the first player inventory slot number</li>
 * </ul>
 */
public abstract class DefaultMenu extends MenuBase {

    protected final Player player;
    protected final Level level;

    // Used for automatic quickMoveStack. To further restrict this use Slot#isItemValid.
    public final int firstOutputSlot;
    public final int firstInventorySlot;

    protected DefaultMenu(@Nullable MenuType<?> type, int windowId, Level level, Inventory inventory, Player player, int firstOutputSlot, int firstInventorySlot) {
        super(type, windowId, inventory);
        this.player = player;
        this.level = level;
        this.firstOutputSlot = firstOutputSlot;
        this.firstInventorySlot = firstInventorySlot;
    }

    public Level getLevel() {
        return this.level;
    }

    @Nonnull
    @Override
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = this.f_38839_.get(index);
        //noinspection ConstantConditions
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();

            final int inventorySize = this.firstInventorySlot;
            final int playerInventoryEnd = inventorySize + 27;
            final int playerHotBarEnd = playerInventoryEnd + 9;

            if (index < this.firstOutputSlot) {
                if (!this.m_38903_(stack, inventorySize, playerHotBarEnd, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else if (index >= inventorySize) {
                if (!this.m_38903_(stack, 0, this.firstOutputSlot, false)) {
                    return ItemStack.f_41583_;
                } else if (index < playerInventoryEnd) {
                    if (!this.m_38903_(stack, playerInventoryEnd, playerHotBarEnd, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (index < playerHotBarEnd && !this.m_38903_(stack, inventorySize, playerInventoryEnd, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(stack, inventorySize, playerHotBarEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }
}
