package org.moddingx.libx.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;

import javax.annotation.Nonnull;

/**
 * {@link EntityDataSerializer Data serializers} for enums. It needs to be registered in order to be used.
 */
public class EnumDataSerializer<T extends Enum<T>> implements EntityDataSerializer<T> {
    
    private final Class<T> enumClass;

    public EnumDataSerializer(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public void m_6856_(@Nonnull FriendlyByteBuf buffer, @Nonnull T value) {
        buffer.m_130068_(value);
    }

    @Nonnull
    @Override
    public T m_6709_(@Nonnull FriendlyByteBuf buffer) {
        return buffer.m_130066_(this.enumClass);
    }

    @Nonnull
    @Override
    public T m_7020_(@Nonnull T value) {
        return value;
    }
}
