package org.moddingx.libx.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

import javax.annotation.Nonnull;

/**
 * A {@link BlockEntityRenderer} that before calling the actual render code rotates the {@link PoseStack}
 * depending on the facing. This may only be used with blocks that have the property {@link BlockStateProperties#FACING}.
 * The {@link BlockEntity block entity} should be rendered as if it was facing up.
 */
public abstract class DirectionalBlockRenderer<T extends BlockEntity> extends TransformingBlockRenderer<T> {

    @Override
    protected final void transform(@Nonnull T blockEntity, float partialTicks, @Nonnull PoseStack poseStack) {
        Direction facing = blockEntity.m_58900_().m_61143_(BlockStateProperties.f_61372_);
        float xRot = switch (facing) {
            case UP -> 0;
            case DOWN -> 180;
            default -> 90;
        };
        float yRot = facing.m_122434_() == Direction.Axis.Y ? 0 : facing.m_122435_();
        poseStack.m_85837_(0.5D, 0.5D, 0.5D);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(yRot));
        poseStack.m_85837_(-0.5D, -0.5D, -0.5D);
    }
}
