package org.moddingx.libx.sandbox.generator;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.moddingx.libx.impl.sandbox.FakeHolder;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.surface.BiomeSurface;
import org.moddingx.libx.sandbox.surface.SurfaceRuleSet;

import javax.annotation.Nonnull;
import java.util.Optional;
import java.util.Set;

/**
 * A version of {@link NoiseBasedChunkGenerator} that allows overriding the surface rules, taking {@link BiomeSurface}
 * into account.
 */
public class ExtendedNoiseChunkGenerator extends NoiseBasedChunkGenerator {

    public static final Codec<ExtendedNoiseChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_),
            NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.actualSettings),
            SurfaceRuleSet.CODEC.optionalFieldOf("surface_override").forGetter(gen -> gen.surfaceOverride)
    ).apply(instance, ExtendedNoiseChunkGenerator::new));
    
    private final Optional<Holder<SurfaceRuleSet>> surfaceOverride;
    private final Holder<NoiseGeneratorSettings> actualSettings;
    private final FakeHolder<NoiseGeneratorSettings> fakeSettings;

    public ExtendedNoiseChunkGenerator(BiomeSource biomes, Holder<NoiseGeneratorSettings> settings, Optional<Holder<SurfaceRuleSet>> surfaceOverride) {
        this(biomes, settings, new FakeHolder<>(settings), surfaceOverride);
    }
    
    private ExtendedNoiseChunkGenerator(BiomeSource biomes, Holder<NoiseGeneratorSettings> settings, FakeHolder<NoiseGeneratorSettings> delegate, Optional<Holder<SurfaceRuleSet>> surfaceOverride) {
        super(biomes, delegate);
        this.surfaceOverride = surfaceOverride;
        this.actualSettings = settings;
        this.fakeSettings = delegate;
    }

    public void init(RegistryAccess access) {
        if (this.surfaceOverride.isPresent()) {
            NoiseGeneratorSettings settings = this.actualSettings.get();
            SurfaceRuleSet set = this.surfaceOverride.get().get();
            Set<Holder<Biome>> biomes = this.f_62137_.m_207840_();
            SurfaceRules.RuleSource surfaceRule = set.build(access.m_175515_(Registries.f_256952_), access.m_175515_(SandBox.BIOME_SURFACE), biomes, this.actualSettings.get());
            this.fakeSettings.set(Holder.m_205709_(withSurface(settings, surfaceRule)));
        }
    }

    @Nonnull
    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @Nonnull
    @Override
    public Holder<NoiseGeneratorSettings> m_224341_() {
        return this.actualSettings;
    }

    @Override
    public boolean m_224221_(@Nonnull ResourceKey<NoiseGeneratorSettings> settings) {
        return this.actualSettings.m_203565_(settings);
    }
    
    private static NoiseGeneratorSettings withSurface(NoiseGeneratorSettings settings, SurfaceRules.RuleSource surfaceRule) {
        return new NoiseGeneratorSettings(
                 settings.f_64439_(),
                 settings.f_64440_(),
                 settings.f_64441_(),
                 settings.f_209353_(),
                 surfaceRule,
                 settings.f_224370_(),
                 settings.f_64444_(),
                 settings.f_64445_(),
                 settings.f_158533_(),
                 settings.m_209369_(),
                 settings.f_209354_()
        );
    }
}
