package org.moddingx.libx.sandbox.placement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

import javax.annotation.Nonnull;

/**
 * A {@link PlacementFilter} for filtering by the absolute placement position.
 */
public class HeightPlacementFilter extends PlacementFilter {

    public static final Codec<HeightPlacementFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            VerticalAnchor.f_158914_.fieldOf("min_inclusive").forGetter(filter -> filter.minInclusive),
            VerticalAnchor.f_158914_.fieldOf("max_inclusive").forGetter(filter -> filter.maxInclusive)
    ).apply(instance, HeightPlacementFilter::new));
    
    public static final PlacementModifierType<HeightPlacementFilter> TYPE = () -> CODEC;

    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;

    /**
     * Creates a new {@link HeightPlacementFilter}.
     * 
     * @param minInclusive The minimum height the {@link PlacedFeature} can generate on.
     * @param maxInclusive The maximum height the {@link PlacedFeature} can generate on.
     */
    public HeightPlacementFilter(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }
    
    @Nonnull
    @Override
    public PlacementModifierType<?> m_183327_() {
        return TYPE;
    }

    @Override
    protected boolean m_213917_(@Nonnull PlacementContext context, @Nonnull RandomSource random, @Nonnull BlockPos pos) {
        return this.minInclusive.m_142322_(context) <= pos.m_123342_() && this.maxInclusive.m_142322_(context) >= pos.m_123342_();
    }
}
