package org.moddingx.libx.screen;

import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import org.moddingx.libx.config.gui.EditorOps;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * An {@link AbstractWidget} that is composed of multiple other widgets. These
 * widgets are positioned relative to this widget. You can add these widgets in
 * the constructor.
 */
public abstract class Panel extends AbstractWidget implements ContainerEventHandler, EditorOps {

    private final List<GuiEventListener> children = new ArrayList<>();
    private final List<Renderable> renderables = new ArrayList<>();

    @Nullable
    private GuiEventListener focused = null;
    private boolean dragging = false;

    public Panel(int x, int y, int width, int height) {
        super(x, y, width, height, Component.m_237119_());
    }

    /**
     * Adds a widget that can be rendered.
     */
    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        this.renderables.add(widget);
        this.children.add(widget);
        return widget;
    }

    /**
     * Adds a component that can be rendered.
     */
    protected <T extends Renderable> T addRenderableOnly(T widget) {
        this.renderables.add(widget);
        return widget;
    }

    /**
     * Adds a widget to listen to events.
     */
    protected <T extends GuiEventListener> T addWidget(T widget) {
        this.children.add(widget);
        return widget;
    }

    @Nonnull
    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void m_87963_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(this.m_252754_(), this.m_252907_(), 0);
        for (Renderable widget : this.renderables) {
            widget.m_88315_(graphics, mouseX - this.m_252754_(), mouseY - this.m_252907_(), partialTicks);
        }
        graphics.m_280168_().m_85849_();
    }

    @Nonnull
    @Override
    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        return ContainerEventHandler.super.m_94729_(mouseX - this.m_252754_(), mouseY - this.m_252907_());
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children) {
            if (child.m_6375_(mouseX - this.m_252754_(), mouseY - this.m_252907_(), button)) {
                this.m_7522_(child);
                if (button == 0) this.m_7897_(true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7897_(false);
        return this.m_94729_(mouseX, mouseY).filter(child -> child.m_6348_(mouseX - this.m_252754_(), mouseY - this.m_252907_(), button)).isPresent();
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.focused != null && this.dragging && button == 0 && this.focused.m_7979_(mouseX - this.m_252754_(), mouseY - this.m_252907_(), button, dragX - this.m_252754_(), dragY - this.m_252907_());
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.m_94729_(mouseX, mouseY).filter(child -> child.m_6050_(mouseX - this.m_252754_(), mouseY - this.m_252907_(), delta)).isPresent();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return ContainerEventHandler.super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return ContainerEventHandler.super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_5534_(char value, int modifiers) {
        return ContainerEventHandler.super.m_5534_(value, modifiers);
    }

    @Override
    public void m_168797_(@Nonnull NarrationElementOutput output) {
        //
    }

    @Override
    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        this.updateChildFocus();
    }

    @Nullable
    @Override
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    @Override
    public void m_7522_(@Nullable GuiEventListener focused) {
        this.focused = this.children.contains(focused) ? focused : null;
        this.m_93692_(focused != null);
    }

    private void updateChildFocus() {
        for (GuiEventListener child : this.children) {
            boolean shouldBeFocused = this.m_93696_() && child == this.focused;
            if (child.m_93696_() != shouldBeFocused) {
                child.m_93692_(shouldBeFocused);
            }
        }
    }

    @Nullable
    @Override
    public ComponentPath m_264435_() {
        return ContainerEventHandler.super.m_264435_();
    }

    @Nullable
    @Override
    public ComponentPath m_264064_(@Nonnull FocusNavigationEvent event) {
        return ContainerEventHandler.super.m_264064_(event);
    }

    @Override
    public boolean m_7282_() {
        return this.dragging;
    }

    @Override
    public void m_7897_(boolean dragging) {
        this.dragging = dragging;
    }

    @Override
    public void enabled(boolean enabled) {
        for (GuiEventListener child : this.children) {
            EditorOps.wrap(child).enabled(enabled);
        }
    }
}
