package org.moddingx.libx.screen.text;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.lwjgl.glfw.GLFW;
import org.moddingx.libx.impl.screen.text.TextScreenContent;
import org.moddingx.libx.render.RenderHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

/**
 * A screen to display mostly text and optionally some widgets defined by a {@link ComponentLayout}.
 */
public class TextScreen extends Screen {
    
    private final ComponentLayout layout;
    private final int displayWidth;
    
    @Nullable
    private TextScreenContent content;
    
    public TextScreen(ComponentLayout layout) {
        this(layout, 176);
    }
    
    public TextScreen(ComponentLayout layout, int width) {
        super(Optional.ofNullable(layout.title()).orElse(Component.m_237119_()));
        this.layout = layout;
        this.displayWidth = width;
        this.content = null;
    }

    private int left() {
        if (this.content == null) return 0;
        return (this.f_96543_ - this.content.width()) / 2;
    }

    private int top() {
        if (this.content == null) return 0;
        return (this.f_96544_ - this.content.height()) / 2;
    }
    
    @Override
    protected void m_7856_() {
        this.content = new TextScreenContent(this.f_96547_, this.displayWidth, this.layout.alignComponents(this.f_96547_, this.displayWidth));
        this.content.addWidgets(this.left(), this.top(), this::m_142416_);
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        if (this.content == null) return;
        int left = this.left();
        int top = this.top();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0, 0, 20);
        this.drawBackground(graphics, left - 10, top - 10, this.content.width() + 20, this.content.height() + 20, partialTick);
        graphics.m_280168_().m_252880_(0, 0, 100);
        this.content.render(graphics, left, top);
        graphics.m_280168_().m_85849_();
        
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0, 0, 200);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280168_().m_85849_();

        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0, 0, 500);
        Style tooltip = this.content.hoveredStyle(mouseX - left, mouseY - top);
        if (tooltip != null) {
            graphics.m_280168_().m_252880_(0, 0, 20);
            RenderHelper.resetColor();
            graphics.m_280304_(this.f_96547_, tooltip, mouseX, mouseY);
        }
        graphics.m_280168_().m_85849_();
    }
    
    protected void drawBackground(GuiGraphics graphics, int x, int y, int width, int height, float partialTick) {
        RenderHelper.renderGuiBackground(graphics, x, y, width, height);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == GLFW.GLFW_MOUSE_BUTTON_LEFT && this.content != null) {
            Style click = this.content.hoveredStyle(((int) mouseX) - this.left(), ((int) mouseY) - this.top());
            if (click != null) {
                return this.m_5561_(click);
            }
        }
        return false;
    }

    @Override
    protected void m_6697_(@Nonnull String text, boolean overwrite) {
        Minecraft.m_91087_().m_91326_(text);
    }
}
