package org.moddingx.libx.util.game;

import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

import java.util.function.Predicate;

/**
 * Utilities to send messages to a set of {@link Player players} on the {@link MinecraftServer server}.
 */
public class ServerMessages {

    /**
     * Sends a {@link Component text component} to every {@link Player player} on the server.
     */
    public static void broadcast(Level level, Component message) {
        broadcastTo(level, p -> true, message);
    }
    
    /**
     * Sends a {@link Component text component} to all {@link Player player} matching a predicate.
     */
    public static void broadcastTo(Level level, Predicate<? super ServerPlayer> condition, Component message) {
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            server.m_6846_().m_11314_().forEach(player -> {
                if (condition.test(player)) {
                    player.m_213846_(message);
                }
            });
        }
    }
}
