/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.modbadges;

import java.nio.file.Path;
import org.moddingx.modbadges.BadgeGenerator;
import org.moddingx.modbadges.platform.CurseApi;
import org.moddingx.modbadges.platform.ModrinthApi;
import org.moddingx.modbadges.route.PlatformBadgeRoute;
import org.moddingx.modbadges.route.VersionRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Route;
import spark.Service;

public class BadgesServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BadgesServer.class);
    private final String version;
    private final Service spark;

    public BadgesServer(String version, int port, SslData ssl, int threads, String curseToken) {
        LOGGER.info("Starting Server on port {}", (Object)port);
        this.version = version;
        this.spark = Service.ignite();
        this.spark.port(port);
        LOGGER.info("Running on {} threads", (Object)threads);
        this.spark.threadPool(threads, threads, -1);
        if (ssl != null) {
            this.spark.secure(ssl.cert().toAbsolutePath().normalize().toString(), ssl.key(), null, null);
        } else {
            LOGGER.warn("Running without SSL");
        }
        ModrinthApi modrinthApi = new ModrinthApi();
        CurseApi curseApi = new CurseApi(curseToken);
        this.spark.get("/version", (Route)new VersionRoute(this.spark, this.version));
        this.spark.get("/modrinth/versions/:projectId", (Route)new PlatformBadgeRoute(this.spark, BadgeGenerator.Platform.MODRINTH, BadgeGenerator.BadgeType.GAME_VERSIONS, modrinthApi));
        this.spark.get("/modrinth/downloads/:projectId", (Route)new PlatformBadgeRoute(this.spark, BadgeGenerator.Platform.MODRINTH, BadgeGenerator.BadgeType.DOWNLOADS, modrinthApi));
        this.spark.get("/curseforge/versions/:projectId", (Route)new PlatformBadgeRoute(this.spark, BadgeGenerator.Platform.CURSEFORGE, BadgeGenerator.BadgeType.GAME_VERSIONS, curseApi));
        this.spark.get("/curseforge/downloads/:projectId", (Route)new PlatformBadgeRoute(this.spark, BadgeGenerator.Platform.CURSEFORGE, BadgeGenerator.BadgeType.DOWNLOADS, curseApi));
    }

    public String version() {
        return this.version;
    }

    public void shutdown() {
        this.spark.stop();
    }

    public record SslData(String key, Path cert) {
    }
}

