/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.modbadges;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Manifest;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.moddingx.modbadges.BadgesServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws IOException {
        int port;
        String version;
        try (InputStream in = Main.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(in);
            version = manifest.getMainAttributes().getValue("Implementation-Version");
        }
        OptionParser options = new OptionParser(false);
        OptionSpecBuilder specDocker = options.accepts("docker", "Run in Docker mode. This will load secrets as docker secrets.");
        ArgumentAcceptingOptionSpec specToken = options.accepts("curse-token", "The CurseForge API token to use").availableUnless((OptionSpec)specDocker, new OptionSpec[0]).requiredUnless((OptionSpec)specDocker, new OptionSpec[0]).withRequiredArg();
        OptionSpecBuilder specNoSsl = options.accepts("no-ssl", "Disable SSL. For testing only.");
        ArgumentAcceptingOptionSpec specSsl = options.accepts("ssl", "The SSL certificate fle to use.").availableUnless((OptionSpec)specDocker, new OptionSpec[]{specNoSsl}).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE}));
        ArgumentAcceptingOptionSpec specSslKey = options.accepts("ssl-key", "The password of the SSL certificate.").availableUnless((OptionSpec)specDocker, new OptionSpec[]{specNoSsl}).withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec specPort = options.accepts("port", "The port to run on.").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec specThreads = options.accepts("threads", "How many threads the server should use.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Math.min(4, Runtime.getRuntime().availableProcessors()), (Object[])new Integer[0]);
        OptionSet set = options.parse(args);
        if (version == null) {
            version = "UNKNOWN";
            LOGGER.warn("Failed to detect version, falling back to {}", (Object)version);
        } else {
            LOGGER.info("Running ModBadges v{}", (Object)version);
        }
        boolean docker = set.has((OptionSpec)specDocker);
        boolean useSsl = !set.has((OptionSpec)specNoSsl);
        BadgesServer.SslData ssl = null;
        int n = set.has((OptionSpec)specPort) ? (Integer)set.valueOf((OptionSpec)specPort) : (port = useSsl ? 443 : 80);
        if (useSsl) {
            ssl = new BadgesServer.SslData(docker ? Main.dockerSecret("ssl_keystore_password") : (String)set.valueOf((OptionSpec)specSslKey), docker ? Main.dockerSecretPath("ssl_keystore") : ((Path)set.valueOf((OptionSpec)specSsl)).toAbsolutePath().normalize());
        }
        String curseToken = docker ? Main.dockerSecret("curse_token") : (String)set.valueOf((OptionSpec)specToken);
        BadgesServer server = new BadgesServer(version, port, ssl, (Integer)set.valueOf((OptionSpec)specThreads), curseToken);
        Runtime.getRuntime().addShutdownHook(new Thread(server::shutdown));
        LOGGER.info("Initialisation complete.");
    }

    private static String dockerSecret(String id) throws IOException {
        return Files.readString(Main.dockerSecretPath(id));
    }

    private static Path dockerSecretPath(String id) {
        return Paths.get("/", "run", "secrets", id);
    }
}

