/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.modlistcreator.changelogger;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.moddingx.modlistcreator.changelogger.ChangelogFormatter;
import org.moddingx.modlistcreator.output.OutputTarget;
import org.moddingx.modlistcreator.platform.Modpack;
import org.moddingx.modlistcreator.util.EnumConverters;
import org.moddingx.modlistcreator.util.OptionUtil;

public class Changelogger {
    public static void run(String[] args) throws IOException {
        OptionSet set;
        OptionParser options = new OptionParser();
        ArgumentAcceptingOptionSpec specOld = options.acceptsAll(List.of("o", "old"), "Defines the old modpack zip or json file").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING}));
        ArgumentAcceptingOptionSpec specNew = options.acceptsAll(List.of("n", "new"), "Defines the new modpack zip or json file").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING}));
        ArgumentAcceptingOptionSpec specOutput = options.accepts("output", "Defines the output file name").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec specFormat = options.accepts("format", "The output format to use").withRequiredArg().withValuesConvertedBy(EnumConverters.enumArg(OutputTarget.Type.class)).defaultsTo((Object)OutputTarget.Type.MARKDOWN, (Object[])new OutputTarget.Type[0]);
        try {
            set = options.parse(args);
            if (!set.has((OptionSpec)specOld)) {
                OptionUtil.missing(options, specOld);
            }
            if (!set.has((OptionSpec)specNew)) {
                OptionUtil.missing(options, specNew);
            }
            if (!set.has((OptionSpec)specOutput)) {
                OptionUtil.missing(options, specOutput);
            }
        }
        catch (OptionException e) {
            System.err.println(e.getMessage() + "\n");
            options.printHelpOn((OutputStream)System.err);
            System.exit(1);
            throw new Error();
        }
        Modpack from = Modpack.fromPath((Path)set.valueOf((OptionSpec)specOld));
        Modpack to = Modpack.fromPath((Path)set.valueOf((OptionSpec)specNew));
        Path output = Paths.get((String)set.valueOf((OptionSpec)specOutput), new String[0]);
        Files.writeString(output, (CharSequence)ChangelogFormatter.format(from, to, (OutputTarget.Type)((Object)set.valueOf((OptionSpec)specFormat))), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        System.exit(0);
    }
}

