/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.modlistcreator.modlist;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiFunction;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.moddingx.modlistcreator.modlist.ModListFormatter;
import org.moddingx.modlistcreator.output.OutputTarget;
import org.moddingx.modlistcreator.platform.Modpack;
import org.moddingx.modlistcreator.util.EnumConverters;
import org.moddingx.modlistcreator.util.OptionUtil;

public class ModListCreator {
    public static void run(String[] args) throws IOException {
        OptionSet set;
        OptionParser options = new OptionParser();
        OptionSpecBuilder specNoHeader = options.accepts("no-header", "Generates the file without pack name and version");
        OptionSpecBuilder specDetailed = options.accepts("detailed", "Shows exact version of each mod");
        ArgumentAcceptingOptionSpec specFormat = options.accepts("format", "The output format to use").withRequiredArg().withValuesConvertedBy(EnumConverters.enumArg(OutputTarget.Type.class)).withValuesSeparatedBy(",").defaultsTo((Object)OutputTarget.Type.MARKDOWN, (Object[])new OutputTarget.Type[0]);
        ArgumentAcceptingOptionSpec specOutput = options.accepts("output", "Defines the output path for generated files. If --pattern is set, describes a directory for output files, else a concrete file.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec specPattern = options.accepts("pattern", "Defines the output file name pattern. %n is replaced with pack name, %v with pack version.").withRequiredArg().ofType(String.class);
        NonOptionArgumentSpec specInput = options.nonOptions("Input files. Can be either modpack zips or json files.").withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE}));
        try {
            set = options.parse(args);
            if (!set.has((OptionSpec)specOutput)) {
                OptionUtil.missing(options, specOutput);
            }
            if (!set.has((OptionSpec)specPattern) && set.valuesOf((OptionSpec)specFormat).size() != 1) {
                OptionUtil.missing(options, specPattern, "Name pattern needed for multiple output formats");
            }
            if (!set.has((OptionSpec)specPattern) && set.valuesOf((OptionSpec)specInput).size() != 1) {
                OptionUtil.missing(options, specPattern, "Name pattern needed for multiple input files");
            }
            if (set.valuesOf((OptionSpec)specInput).isEmpty()) {
                OptionUtil.missing(options, specInput, "No inputs");
            }
        }
        catch (OptionException e) {
            System.err.println(e.getMessage() + "\n");
            options.printHelpOn((OutputStream)System.err);
            System.exit(1);
            throw new Error();
        }
        BiFunction<Modpack, OutputTarget.Type, Path> outputPaths = OptionUtil.outputPathFunc((Path)set.valueOf((OptionSpec)specOutput), set.has((OptionSpec)specPattern) ? (String)set.valueOf((OptionSpec)specPattern) : null);
        List outputTypes = set.valuesOf((OptionSpec)specFormat).stream().distinct().toList();
        boolean includeHeader = !set.has((OptionSpec)specNoHeader);
        boolean detailed = set.has((OptionSpec)specDetailed);
        List inputs = set.valuesOf((OptionSpec)specInput);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Math.min(inputs.size(), Runtime.getRuntime().availableProcessors() - 1));
        ArrayList joins = new ArrayList();
        for (Path path : inputs) {
            joins.add(executor.submit(() -> {
                try {
                    Modpack pack = Modpack.fromPath(path);
                    for (OutputTarget.Type type : outputTypes) {
                        Path outputPath = (Path)outputPaths.apply(pack, type);
                        if (!Files.exists(outputPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                        }
                        Files.writeString(outputPath, (CharSequence)ModListFormatter.format(pack, type, includeHeader, detailed), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed for path: " + path, e);
                }
            }));
        }
        for (Future future : joins) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace();
            }
        }
        System.exit(0);
    }
}

