/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.modlistcreator.output;

import java.net.URI;
import java.util.Stack;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.moddingx.modlistcreator.output.OutputTarget;

public class HtmlTarget
implements OutputTarget {
    private final Element tag = new Element("body");
    private final Stack<Element> lists = new Stack();

    @Override
    public void addHeader(String content) {
        this.tag.appendChild((Node)new Element("h2").append(content));
    }

    @Override
    public void addSubHeader(String content) {
        this.tag.appendChild((Node)new Element("h3").append(content));
    }

    @Override
    public void addParagraph(String content) {
        this.tag.appendChild((Node)new Element("p").append(content));
    }

    @Override
    public void beginList(boolean numbered) {
        this.lists.push(new Element(numbered ? "ol" : "ul"));
    }

    @Override
    public void addListElement(String content) {
        this.lists.peek().appendChild((Node)new Element("li").append(content));
    }

    @Override
    public void endList() {
        Element elem = this.lists.pop();
        if (this.lists.isEmpty()) {
            this.tag.appendChild((Node)elem);
        } else {
            this.lists.peek().appendChild((Node)elem);
        }
        this.tag.appendChild((Node)new Element("br"));
    }

    @Override
    public String formatLink(String text, URI url) {
        return new Element("a").attr("href", url.toString()).append(text).outerHtml();
    }

    @Override
    public String result() {
        return this.tag.html();
    }
}

