/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.modlistcreator.platform;

import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.moddingx.modlistcreator.Main;
import org.moddingx.modlistcreator.platform.CurseModpack;
import org.moddingx.modlistcreator.platform.ModrinthModpack;

public interface Modpack {
    public String title();

    public Minecraft minecraft();

    public String version();

    public List<File> files();

    public static Modpack fromPath(Path path) throws IOException {
        try {
            return Modpack.loadZip(path);
        }
        catch (ProviderNotFoundException e) {
            return Modpack.load(path);
        }
    }

    public static Modpack loadZip(Path path) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + path.toAbsolutePath().normalize().toUri()), Map.of());){
            for (Type type : Type.values()) {
                Path manifest = fs.getPath("/", new String[0]).resolve(type.manifestPath).toAbsolutePath().normalize();
                if (!Files.isRegularFile(manifest, new LinkOption[0])) continue;
                Modpack modpack = Modpack.load(manifest, type);
                return modpack;
            }
            throw new IOException("Failed to load modpack: Format unknown, no manifest file found in archive");
        }
    }

    public static Modpack load(Path path) throws IOException {
        JsonElement json;
        try (BufferedReader reader = Files.newBufferedReader(path);){
            json = (JsonElement)Main.GSON.fromJson((Reader)reader, JsonElement.class);
        }
        for (Type type : Type.values()) {
            Optional<? extends Modpack> pack = type.factory.apply(json);
            if (!pack.isPresent()) continue;
            return pack.get();
        }
        throw new IOException("Failed to load modpack: Format unknown, manifest file has no known format");
    }

    public static Modpack load(Path path, Type type) throws IOException {
        JsonElement json;
        try (BufferedReader reader = Files.newBufferedReader(path);){
            json = (JsonElement)Main.GSON.fromJson((Reader)reader, JsonElement.class);
        }
        Optional<? extends Modpack> pack = type.factory.apply(json);
        if (pack.isEmpty()) {
            throw new IOException("Invalid " + type.name().toLowerCase(Locale.ROOT) + " modpack: Invalid manifest");
        }
        return pack.get();
    }

    public static enum Type {
        CURSEFORGE("manifest.json", CurseModpack::load),
        MODRINTH("modrinth.index.json", ModrinthModpack::load);

        private final String manifestPath;
        private final IOFunction<JsonElement, Optional<? extends Modpack>> factory;

        private Type(String manifestPath, IOFunction<JsonElement, Optional<? extends Modpack>> factory) {
            this.manifestPath = manifestPath;
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    public record Minecraft(String version, String loader, String loaderVersion) {
    }

    public record DefaultFile(String projectSlug, String projectName, String fileName, String fileId, String author, URI projectWebsite, URI fileWebsite, URI authorWebsite) implements File
    {
    }

    public static interface File {
        public String projectSlug();

        public String projectName();

        public String fileName();

        public String fileId();

        public String author();

        public URI projectWebsite();

        public URI fileWebsite();

        public URI authorWebsite();
    }
}

