/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.moonstone.model;

import com.google.gson.JsonElement;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Locale;
import org.moddingx.moonstone.logic.FileAccess;
import org.moddingx.moonstone.logic.ProjectAccess;
import org.moddingx.moonstone.model.FileEntry;
import org.moddingx.moonstone.model.FileList$;
import org.moddingx.moonstone.model.FileListIO;
import org.moddingx.moonstone.model.FileListIO$;
import org.moddingx.moonstone.platform.ModdingPlatform;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.MapFactory$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\u0015+\u0001MB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005y!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003F\u0011!I\u0005A!b\u0001\n\u0013Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t5\u0002\u0011\t\u0011)Q\u00057\"Aa\r\u0001B\u0001B\u0003&1\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!y\u0007A!A!\u0002\u0013A\u0007\"\u00029\u0001\t\u0013\t\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003?\u0001\u0001\u0015!\u0003~\u0011!\t\t\u0003\u0001b\u0001\n\u0013a\bbBA\u0012\u0001\u0001\u0006I! \u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\f\u0001\t\u0003\tY\u0003C\u0004\u00020\u0001!\t!a\u000b\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005u\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\ti\u0005\u0001C\u0001\u0003'Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002X\u0001!\t!!\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!a!\u0001\t\u0003\tY\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\u001e9\u00111\u0013\u0016\t\u0002\u0005UeAB\u0015+\u0011\u0003\t9\n\u0003\u0004qM\u0011\u0005\u0011\u0011\u0014\u0005\b\u000373C\u0011AAO\u0005!1\u0015\u000e\\3MSN$(BA\u0016-\u0003\u0015iw\u000eZ3m\u0015\tic&A\u0005n_>t7\u000f^8oK*\u0011q\u0006M\u0001\t[>$G-\u001b8hq*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\fq\u0001\u001d:pU\u0016\u001cG/F\u0001=!\ti\u0004)D\u0001?\u0015\tyD&A\u0003m_\u001eL7-\u0003\u0002B}\ti\u0001K]8kK\u000e$\u0018iY2fgN\f\u0001\u0002\u001d:pU\u0016\u001cG\u000fI\u0001\u0005M&dW-F\u0001F!\tid)\u0003\u0002H}\tQa)\u001b7f\u0003\u000e\u001cWm]:\u0002\u000b\u0019LG.\u001a\u0011\u0002\u0015=tWj\u001c3jM&,G-F\u0001L!\r)DJT\u0005\u0003\u001bZ\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005Uz\u0015B\u0001)7\u0005\u0011)f.\u001b;\u0002\u0017=tWj\u001c3jM&,G\rI\u0001\ta2\fGOZ8s[V\tA\u000b\u0005\u0002V/6\taK\u0003\u0002SY%\u0011\u0001L\u0016\u0002\u0010\u001b>$G-\u001b8h!2\fGOZ8s[\u0006I\u0001\u000f\\1uM>\u0014X\u000eI\u0001\ba2{\u0017\rZ3s!\ta6M\u0004\u0002^CB\u0011aLN\u0007\u0002?*\u0011\u0001MM\u0001\u0007yI|w\u000e\u001e \n\u0005\t4\u0014A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\u001c\u0002\u0015Al5MV3sg&|g.\u0001\u0006q\u0013:\u001cH/\u00197mK\u0012\u00042\u0001X5l\u0013\tQWMA\u0002TKR\u0004\"\u0001\\7\u000e\u0003)J!A\u001c\u0016\u0003\u0013\u0019KG.Z#oiJL\u0018!\u00049EKB,g\u000eZ3oG&,7/\u0001\u0004=S:LGO\u0010\u000b\neN$XO^<ysj\u0004\"\u0001\u001c\u0001\t\u000bij\u0001\u0019\u0001\u001f\t\u000b\rk\u0001\u0019A#\t\u000b%k\u0001\u0019A&\t\u000bIk\u0001\u0019\u0001+\t\u000bik\u0001\u0019A.\t\u000b\u0019l\u0001\u0019A.\t\u000b\u001dl\u0001\u0019\u00015\t\u000b=l\u0001\u0019\u00015\u0002\u0019%t7\u000f^1mY\u0016$W*\u00199\u0016\u0003u\u0004bA`A\u0004\u0003\u0017YW\"A@\u000b\t\u0005\u0005\u00111A\u0001\b[V$\u0018M\u00197f\u0015\r\t)AN\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0005\u007f\n\u0019Q*\u00199\u0011\t\u00055\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005!qm]8o\u0015\u0011\t)\"a\u0006\u0002\r\u001d|wn\u001a7f\u0015\t\tI\"A\u0002d_6LA!!\b\u0002\u0010\tY!j]8o\u000b2,W.\u001a8u\u00035Ign\u001d;bY2,G-T1qA\u0005iA-\u001a9f]\u0012,gnY=NCB\fa\u0002Z3qK:$WM\\2z\u001b\u0006\u0004\b%\u0001\u0003tCZ,G#\u0001(\u0002\u001d%t7\u000f^1mY\u0016$g)\u001b7fgV\t\u0001.A\beKB,g\u000eZ3oGf4\u0015\u000e\\3t\u0003!\tG\u000e\u001c$jY\u0016\u001c\u0018A\u00035bgB\u0013xN[3diR!\u0011QGA\u001e!\r)\u0014qG\u0005\u0004\u0003s1$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007Z\u0001\ra\u001b\u000b\u0005\u0003k\ty\u0004\u0003\u0004;/\u0001\u0007\u00111B\u0001\tM&dW-\u00138g_R!\u0011QIA&!\u0011)\u0014qI6\n\u0007\u0005%cG\u0001\u0004PaRLwN\u001c\u0005\u0007ua\u0001\r!a\u0003\u0002\u001bI,Wn\u001c<f!J|'.Z2u)\rq\u0015\u0011\u000b\u0005\u0006\u0007f\u0001\ra\u001b\u000b\u0004\u001d\u0006U\u0003B\u0002\u001e\u001b\u0001\u0004\tY!A\fsK6|g/\u001a#fa\u0016tG-\u001a8dsB\u0013xN[3diR\u0019a*a\u0017\t\u000b\r[\u0002\u0019A6\u0015\u00079\u000by\u0006\u0003\u0004;9\u0001\u0007\u00111B\u0001\u0016kB$\u0017\r^3Pe\u0006#G\rR3qK:$WM\\2z)\rq\u0015Q\r\u0005\u0006\u0007v\u0001\ra[\u0001\u0004C\u0012$G#\u0002(\u0002l\u00055\u0004\"B\"\u001f\u0001\u0004Y\u0007bBA8=\u0001\u0007\u0011QG\u0001\fSNLen\u001d;bY2,G-A\btKR$U\r]3oI\u0016t7-[3t)\rq\u0015Q\u000f\u0005\u0007\u0003oz\u0002\u0019\u00015\u0002\u000b\u0019LG.Z:\u0002\r1|\u0017\rZ3s+\u0005Y\u0016A\u00037pC\u0012,'o\u0018\u0013fcR\u0019a*!!\t\r\u0005e\u0014\u00051\u0001\\\u0003%i7MV3sg&|g.A\u0007nGZ+'o]5p]~#S-\u001d\u000b\u0004\u001d\u0006%\u0005BBABG\u0001\u00071,A\u0006eKJLg/Z#naRLHc\u0001:\u0002\u0010\"1\u0011\u0011\u0013\u0013A\u0002Q\u000b1B\\3x!2\fGOZ8s[\u0006Aa)\u001b7f\u0019&\u001cH\u000f\u0005\u0002mMM\u0011a\u0005\u000e\u000b\u0003\u0003+\u000baa\u0019:fCR,G\u0003CAP\u0003C\u000b\u0019+!*\u0011\tU\n9E\u001d\u0005\u0006u!\u0002\r\u0001\u0010\u0005\u0006\u0007\"\u0002\r!\u0012\u0005\u0006\u0013\"\u0002\ra\u0013")
public class FileList {
    private final ProjectAccess project;
    private final FileAccess file;
    private final Function0<BoxedUnit> onModified;
    private final ModdingPlatform platform;
    private String pLoader;
    private String pMcVersion;
    private final Map<JsonElement, FileEntry> installedMap;
    private final Map<JsonElement, FileEntry> dependencyMap;

    public static Option<FileList> create(ProjectAccess project, FileAccess file, Function0<BoxedUnit> onModified) {
        return FileList$.MODULE$.create(project, file, onModified);
    }

    public ProjectAccess project() {
        return this.project;
    }

    public FileAccess file() {
        return this.file;
    }

    private Function0<BoxedUnit> onModified() {
        return this.onModified;
    }

    public ModdingPlatform platform() {
        return this.platform;
    }

    private Map<JsonElement, FileEntry> installedMap() {
        return this.installedMap;
    }

    private Map<JsonElement, FileEntry> dependencyMap() {
        return this.dependencyMap;
    }

    public void save() {
        this.project().writeAction(() -> {
            OutputStreamWriter writer = new OutputStreamWriter(this.file().openForWriting(this));
            FileListIO$.MODULE$.save(writer, new FileListIO.Data(this.platform(), this.loader(), this.mcVersion(), this.installedMap().values().toSet(), this.dependencyMap().values().toSet()));
            writer.close();
        });
    }

    public Set<FileEntry> installedFiles() {
        return this.installedMap().values().toSet();
    }

    public Set<FileEntry> dependencyFiles() {
        return this.dependencyMap().values().toSet();
    }

    public Set<FileEntry> allFiles() {
        return (Set)this.installedMap().values().toSet().$bar(this.dependencyMap().values().toSet());
    }

    public boolean hasProject(FileEntry file) {
        return this.hasProject(file.project());
    }

    public boolean hasProject(JsonElement project) {
        return this.installedMap().contains(project) || this.dependencyMap().contains(project);
    }

    public Option<FileEntry> fileInfo(JsonElement project) {
        return this.installedMap().get(project).orElse((Function0<Option> & Serializable)() -> this.dependencyMap().get(project));
    }

    public void removeProject(FileEntry file) {
        this.removeProject(file.project());
    }

    public void removeProject(JsonElement project) {
        boolean b1 = this.installedMap().remove(project).isDefined();
        boolean b2 = this.dependencyMap().remove(project).isDefined();
        if (b1 || b2) {
            this.onModified().apply$mcV$sp();
            return;
        }
    }

    public void removeDependencyProject(FileEntry file) {
        this.removeDependencyProject(file.project());
    }

    public void removeDependencyProject(JsonElement project) {
        if (this.dependencyMap().remove(project).isDefined()) {
            this.onModified().apply$mcV$sp();
            return;
        }
    }

    public void updateOrAddDependency(FileEntry file) {
        if (this.installedMap().contains(file.project())) {
            boolean hasChanges;
            boolean removedDep = this.dependencyMap().remove(file.project()).isDefined();
            FileEntry fileEntry = file;
            Object v = this.installedMap().apply(file.project());
            boolean bl = (fileEntry == null ? v != null : !((Object)fileEntry).equals(v)) ? true : (hasChanges = false);
            if (hasChanges) {
                this.installedMap().update(file.project(), file);
            }
            if (removedDep || hasChanges) {
                this.onModified().apply$mcV$sp();
                return;
            }
            return;
        }
        if (this.dependencyMap().contains(file.project())) {
            FileEntry fileEntry = file;
            Object v = this.dependencyMap().apply(file.project());
            if (fileEntry == null ? v != null : !((Object)fileEntry).equals(v)) {
                this.dependencyMap().update(file.project(), file);
                this.onModified().apply$mcV$sp();
                return;
            }
            return;
        }
        this.dependencyMap().put(file.project(), file);
        this.onModified().apply$mcV$sp();
    }

    public void add(FileEntry file, boolean isInstalled) {
        this.installedMap().remove(file.project());
        this.dependencyMap().remove(file.project());
        if (isInstalled) {
            this.installedMap().update(file.project(), file);
        } else {
            this.dependencyMap().update(file.project(), file);
        }
        this.onModified().apply$mcV$sp();
    }

    public void setDependencies(Set<FileEntry> files) {
        this.dependencyMap().clear();
        files.foreach((Function1<FileEntry, Object> & Serializable)file -> {
            FileList.$anonfun$setDependencies$1(this, file);
            return BoxedUnit.UNIT;
        });
        this.onModified().apply$mcV$sp();
    }

    public String loader() {
        return this.pLoader;
    }

    public void loader_$eq(String loader) {
        boolean didChange;
        String string = this.pLoader;
        String string2 = loader.toLowerCase(Locale.ROOT);
        boolean bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (didChange = false);
        if (didChange) {
            this.pLoader = loader.toLowerCase(Locale.ROOT);
            this.onModified().apply$mcV$sp();
            return;
        }
    }

    public String mcVersion() {
        return this.pMcVersion;
    }

    public void mcVersion_$eq(String mcVersion) {
        boolean didChange;
        String string = this.pMcVersion;
        String string2 = mcVersion.toLowerCase(Locale.ROOT);
        boolean bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (didChange = false);
        if (didChange) {
            this.pMcVersion = mcVersion.toLowerCase(Locale.ROOT);
            this.onModified().apply$mcV$sp();
            return;
        }
    }

    public FileList deriveEmpty(ModdingPlatform newPlatform) {
        FileList derived = new FileList(this.project(), this.file(), this.onModified(), newPlatform, this.loader(), this.mcVersion(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        derived.onModified().apply$mcV$sp();
        return derived;
    }

    public static final /* synthetic */ void $anonfun$setDependencies$1(FileList $this, FileEntry file) {
        $this.dependencyMap().update(file.project(), file);
    }

    public FileList(ProjectAccess project, FileAccess file, Function0<BoxedUnit> onModified, ModdingPlatform platform, String pLoader, String pMcVersion, Set<FileEntry> pInstalled, Set<FileEntry> pDependencies) {
        this.project = project;
        this.file = file;
        this.onModified = onModified;
        this.platform = platform;
        this.pLoader = pLoader;
        this.pMcVersion = pMcVersion;
        this.installedMap = pInstalled.groupBy((Function1<FileEntry, JsonElement> & Serializable)x$1 -> x$1.project()).view().mapValues((Function1<Set, FileEntry> & Serializable)x$2 -> (FileEntry)x$2.head()).to(MapFactory$.MODULE$.toFactory(Map$.MODULE$));
        this.dependencyMap = pDependencies.groupBy((Function1<FileEntry, JsonElement> & Serializable)x$3 -> x$3.project()).view().mapValues((Function1<Set, FileEntry> & Serializable)x$4 -> (FileEntry)x$4.head()).to(MapFactory$.MODULE$.toFactory(Map$.MODULE$));
    }
}

