/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.moonstone.platform.modrinth;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.moddingx.moonstone.logic.Destroyable;
import org.moddingx.moonstone.platform.ModList;
import org.moddingx.moonstone.platform.modrinth.ModrinthAPI;
import org.moddingx.moonstone.platform.modrinth.ModrinthProject;
import org.moddingx.moonstone.platform.modrinth.ModrinthTypes$;
import org.moddingx.moonstone.platform.modrinth.ModrinthVersion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006m\u0001!\ta\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB-\u0001A\u0003%1\tC\u0004[\u0001\t\u0007I\u0011B.\t\r\u0001\u0004\u0001\u0015!\u0003]\u0011\u001d\t\u0007A1A\u0005\n\tDa!\u001c\u0001!\u0002\u0013\u0019\u0007b\u00028\u0001\u0005\u0004%IA\u0019\u0005\u0007_\u0002\u0001\u000b\u0011B2\t\u000bA\u0004A\u0011A9\t\u000bQ\u0004A\u0011A;\t\u000b]\u0004A\u0011\u0001=\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005-\u0003\u0001\"\u0011\u0002J\tiQj\u001c3sS:$\bnQ1dQ\u0016T!AG\u000e\u0002\u00115|GM]5oi\"T!\u0001H\u000f\u0002\u0011Ad\u0017\r\u001e4pe6T!AH\u0010\u0002\u00135|wN\\:u_:,'B\u0001\u0011\"\u0003!iw\u000e\u001a3j]\u001eD(\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]u\tQ\u0001\\8hS\u000eL!\u0001M\u0017\u0003\u0017\u0011+7\u000f\u001e:ps\u0006\u0014G.Z\u0001\u0005Y&\u001cH\u000f\u0005\u00024i5\t1$\u0003\u000267\t9Qj\u001c3MSN$\u0018A\u0002\u001fj]&$h\b\u0006\u00029uA\u0011\u0011\bA\u0007\u00023!)\u0011G\u0001a\u0001e\u0005\u0019\u0011\r]5\u0016\u0003u\u0002\"!\u000f \n\u0005}J\"aC'pIJLg\u000e\u001e5B!&\u000bA!\u00199jA\u0005A\u0001O]8kK\u000e$8/F\u0001D!\u0011!\u0015j\u0013,\u000e\u0003\u0015S!AR$\u0002\u000f5,H/\u00192mK*\u0011\u0001jJ\u0001\u000bG>dG.Z2uS>t\u0017B\u0001&F\u0005\ri\u0015\r\u001d\t\u0003\u0019Ns!!T)\u0011\u00059;S\"A(\u000b\u0005A\u001b\u0013A\u0002\u001fs_>$h(\u0003\u0002SO\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011v\u0005\u0005\u0002:/&\u0011\u0001,\u0007\u0002\u0010\u001b>$'/\u001b8uQB\u0013xN[3di\u0006I\u0001O]8kK\u000e$8\u000fI\u0001\tm\u0016\u00148/[8ogV\tA\f\u0005\u0003E\u0013.k\u0006CA\u001d_\u0013\ty\u0016DA\bN_\u0012\u0014\u0018N\u001c;i-\u0016\u00148/[8o\u0003%1XM]:j_:\u001c\b%A\bqe>TWm\u0019;WKJ\u001c\u0018n\u001c8t+\u0005\u0019\u0007\u0003\u0002#J\u0017\u0012\u00042!\u001a6L\u001d\t1\u0007N\u0004\u0002OO&\t\u0001&\u0003\u0002jO\u00059\u0001/Y2lC\u001e,\u0017BA6m\u0005\r\u0019V-\u001d\u0006\u0003S\u001e\n\u0001\u0003\u001d:pU\u0016\u001cGOV3sg&|gn\u001d\u0011\u0002\u001bM,\u0017M]2i%\u0016\u001cX\u000f\u001c;t\u00039\u0019X-\u0019:dQJ+7/\u001e7ug\u0002\nq\u0001\u001d:pU\u0016\u001cG\u000f\u0006\u0002We\")1/\u0004a\u0001\u0017\u0006\u0011\u0011\u000eZ\u0001\bm\u0016\u00148/[8o)\tif\u000fC\u0003t\u001d\u0001\u00071*\u0001\u0007m_\u0006$\u0007K]8kK\u000e$8\u000f\u0006\u0002zyB\u0011aE_\u0005\u0003w\u001e\u0012A!\u00168ji\")Qp\u0004a\u0001}\u0006\u0019\u0011\u000eZ:\u0011\u00071{8*C\u0002\u0002\u0002U\u00131aU3u\u00031aw.\u00193WKJ\u001c\u0018n\u001c8t)\rI\u0018q\u0001\u0005\u0006{B\u0001\rA`\u0001\fO\u0016$h+\u001a:tS>t7\u000f\u0006\u0003\u0002\u000e\u0005=\u0001cA3k;\")\u0001/\u0005a\u0001\u0017\u000611/Z1sG\"$B!!\u0006\u0002\u0018A\u0019QM\u001b,\t\r\u0005e!\u00031\u0001L\u0003\u0015\tX/\u001a:z\u0003\u0019)gnY8eKR\u00191*a\b\t\r\u0005\u00052\u00031\u0001L\u0003\r\u0019HO]\u0001\u000em\u0016\u00148/[8o\r&dG/\u001a:\u0016\u0005\u0005\u001d\u0002\u0003B3k\u0003S\u0001bAJA\u0016\u0017\u0006=\u0012bAA\u0017O\t1A+\u001e9mKJ\u0002B!!\r\u0002@5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003hg>t'\u0002BA\u001d\u0003w\taaZ8pO2,'BAA\u001f\u0003\r\u0019w.\\\u0005\u0005\u0003\u0003\n\u0019DA\u0006Kg>tW\t\\3nK:$\u0018a\u00034bG\u0016$h)\u001b7uKJ,\"!a\f\u0002\u001d5,G/\u00193bi\u0006\u001c\u0005.\u00198hKR\t\u00110A\u0004eKN$(o\\=")
public class ModrinthCache
implements Destroyable {
    private final ModList list;
    private final ModrinthAPI api;
    private final Map<String, ModrinthProject> projects;
    private final Map<String, ModrinthVersion> versions;
    private final Map<String, Seq<String>> projectVersions;
    private final Map<String, Seq<String>> searchResults;

    private ModrinthAPI api() {
        return this.api;
    }

    private Map<String, ModrinthProject> projects() {
        return this.projects;
    }

    private Map<String, ModrinthVersion> versions() {
        return this.versions;
    }

    private Map<String, Seq<String>> projectVersions() {
        return this.projectVersions;
    }

    private Map<String, Seq<String>> searchResults() {
        return this.searchResults;
    }

    public ModrinthProject project(String id) {
        return (ModrinthProject)this.projects().getOrElseUpdate(id, (Function0<ModrinthProject> & Serializable)() -> ModrinthTypes$.MODULE$.project(this.api().request("project/" + this.encode(id), Nil$.MODULE$).getAsJsonObject()));
    }

    public ModrinthVersion version(String id) {
        return (ModrinthVersion)this.versions().getOrElseUpdate(id, (Function0<ModrinthVersion> & Serializable)() -> ModrinthTypes$.MODULE$.version(this.api().request("version/" + this.encode(id), Nil$.MODULE$).getAsJsonObject()));
    }

    public void loadProjects(Set<String> ids) {
        Set missingProjects = (Set)ids.filter((Function1<String, Object> & Serializable)id -> BoxesRunTime.boxToBoolean(ModrinthCache.$anonfun$loadProjects$1(this, id)));
        if (missingProjects.nonEmpty()) {
            JsonArray array = new JsonArray();
            missingProjects.foreach((Function1<String, Object> & Serializable)id -> {
                array.add(id);
                return BoxedUnit.UNIT;
            });
            JsonElement json = this.api().request("projects", ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ids"), array)}));
            CollectionConverters$.MODULE$.IterableHasAsScala(json.getAsJsonArray()).asScala().foreach((Function1<JsonElement, Option> & Serializable)elem -> {
                ModrinthProject project = ModrinthTypes$.MODULE$.project(elem.getAsJsonObject());
                return this.projects().put(project.id(), project);
            });
            return;
        }
    }

    public void loadVersions(Set<String> ids) {
        Set missingVersions = (Set)ids.filter((Function1<String, Object> & Serializable)id -> BoxesRunTime.boxToBoolean(ModrinthCache.$anonfun$loadVersions$1(this, id)));
        if (missingVersions.nonEmpty()) {
            JsonArray array = new JsonArray();
            missingVersions.foreach((Function1<String, Object> & Serializable)id -> {
                array.add(id);
                return BoxedUnit.UNIT;
            });
            JsonElement json = this.api().request("versions", ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ids"), array)}));
            CollectionConverters$.MODULE$.IterableHasAsScala(json.getAsJsonArray()).asScala().foreach((Function1<JsonElement, Option> & Serializable)elem -> {
                ModrinthVersion version = ModrinthTypes$.MODULE$.version(elem.getAsJsonObject());
                return this.versions().put(version.id(), version);
            });
            return;
        }
    }

    public Seq<ModrinthVersion> getVersions(String project) {
        if (this.projectVersions().contains(project)) {
            Seq versions = (Seq)this.projectVersions().apply(project);
            this.loadVersions(versions.toSet());
            return (Seq)versions.map((Function1<String, ModrinthVersion> & Serializable)ver -> this.version((String)ver));
        }
        JsonElement json = this.api().request("project/" + this.encode(project) + "/version", this.versionFilter());
        Builder versionsBuilder = package$.MODULE$.Seq().newBuilder();
        CollectionConverters$.MODULE$.IterableHasAsScala(json.getAsJsonArray()).asScala().foreach((Function1<JsonElement, Builder> & Serializable)elem -> {
            ModrinthVersion version = ModrinthTypes$.MODULE$.version(elem.getAsJsonObject());
            this.versions().put(version.id(), version);
            return (Builder)versionsBuilder.addOne(version);
        });
        Seq builtVersions = (Seq)((SeqOps)versionsBuilder.result()).sortBy((Function1<ModrinthVersion, Instant> & Serializable)x$1 -> x$1.date(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.projectVersions().put(project, (Seq<String>)builtVersions.map((Function1<ModrinthVersion, String> & Serializable)x$2 -> x$2.id()));
        return builtVersions;
    }

    public Seq<ModrinthProject> search(String query) {
        if (this.searchResults().contains(query)) {
            Seq projects = (Seq)this.searchResults().apply(query);
            this.loadVersions(projects.toSet());
            return (Seq)projects.map((Function1<String, ModrinthProject> & Serializable)p -> this.project((String)p));
        }
        JsonObject json = this.api().request("search", ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("query"), query), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("facets"), this.facetFilter()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("limit"), BoxesRunTime.boxToInteger(30))})).getAsJsonObject();
        Builder projectsBuilder = package$.MODULE$.Seq().newBuilder();
        CollectionConverters$.MODULE$.IterableHasAsScala(json.get("hits").getAsJsonArray()).asScala().foreach((Function1<JsonElement, Builder> & Serializable)elem -> {
            ModrinthProject project = ModrinthTypes$.MODULE$.project(elem.getAsJsonObject());
            this.projects().put(project.id(), project);
            return (Builder)projectsBuilder.addOne(project);
        });
        Seq builtProjects = (Seq)projectsBuilder.result();
        this.searchResults().put(query, (Seq<String>)builtProjects.map((Function1<ModrinthProject, String> & Serializable)x$3 -> x$3.id()));
        return builtProjects;
    }

    private String encode(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    private Seq<Tuple2<String, JsonElement>> versionFilter() {
        JsonArray versions = new JsonArray();
        versions.add(this.list.mcVersion());
        JsonArray loaders = new JsonArray();
        loaders.add(this.list.loader());
        return new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("game_versions"), versions)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("loaders"), loaders)), Nil$.MODULE$));
    }

    private JsonElement facetFilter() {
        JsonArray array = new JsonArray();
        JsonArray versions = new JsonArray();
        versions.add("versions:" + this.list.mcVersion());
        array.add(versions);
        JsonArray loaders = new JsonArray();
        loaders.add("categories:" + this.list.loader());
        array.add(loaders);
        return array;
    }

    public void metadataChange() {
        this.projectVersions().clear();
        this.searchResults().clear();
    }

    @Override
    public void destroy() {
        this.projects().clear();
        this.versions().clear();
        this.projectVersions().clear();
        this.searchResults().clear();
    }

    public static final /* synthetic */ boolean $anonfun$loadProjects$1(ModrinthCache $this, String id) {
        return !$this.projects().contains(id);
    }

    public static final /* synthetic */ boolean $anonfun$loadVersions$1(ModrinthCache $this, String id) {
        return !$this.versions().contains(id);
    }

    public ModrinthCache(ModList list) {
        this.list = list;
        this.api = new ModrinthAPI();
        this.projects = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.versions = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.projectVersions = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.searchResults = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }
}

